#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;
attribute vec2 inTexCoord0;

varying vec2 vTexCoord;
varying vec4 fragColor;
#else
in vec3 inVertex;
in vec3 inNormal;
in vec2 inTexCoord0;

out vec2 vTexCoord;
out vec4 fragColor;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform vec4 inColor;

uniform vec3 lightSource1;
uniform vec3 lightSource2;

void main()
{
	float lambert = (max(0.0, dot(inNormal, lightSource1))
		+ max(0.0, dot(inNormal, lightSource2)));

	fragColor = inColor * lambert;
	vTexCoord = inTexCoord0;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
